@../params.sql
-- umoznime pouzitie inicializacnych parametrov
set define on
set echo on

prompt Prihlasime sa ako pouzivatel client
connect terminal/&terminal_pass&db_name

set echo off
prompt Nastavime namespace na bank_is, aby sme nemuseli pouzivat prefixy
pause Pre pokracovanie stlacte Enter
set echo on
alter session set current_schema=bank_is;

set echo off
pause Pre pokracovanie stlacte Enter
prompt Autentifikujeme sa do systemu a nastavime kontext
pause Pre pokracovanie stlacte Enter
set echo on
begin
 terminal_context_pkg.init_context('0123012301230123', -- cislo karty
                                   sys.dbms_crypto.hash(sys.utl_i18n.string_to_raw('123456', 'AL32UTF8'), 
                                                        sys.dbms_crypto.HASH_SH1)); -- SHA-1(pin) 
end;
/


set echo off
pause Pre pokracovanie stlacte Enter
prompt ukazeme cislo uctu, ktore sa nastavilo v kontexte
pause Pre pokracovanie stlacte Enter
set echo on

select sys_context('bank_context','account_no') as account_no from dual;


set echo off
pause Pre pokracovanie stlacte Enter
prompt Vyskusame zadat typ transakcie na ktoru nemame pravo - EBANK_PAY a TELLER_PAY
pause Pre pokracovanie stlacte Enter
set echo on

insert into v_all_i_transaction(id,account_from,account_to,var_sym,amount,created,status,trans_type)
values (seq_transaction_id.nextval, sys_context('bank_context','account_no'), '000000', '111111',100,sysdate, 'NEW', 'EBANK_PAY');

insert into v_all_i_transaction(id,account_from,account_to,var_sym,amount,created,status,trans_type)
values (seq_transaction_id.nextval, sys_context('bank_context','account_no'), '000000', '111111',100,sysdate, 'NEW', 'TELLER_PAY');


set echo off
pause Pre pokracovanie stlacte Enter
prompt Vyskusame zadat platbu CARD_PAY - nad limit (2000)
pause Pre pokracovanie stlacte Enter
set echo on
insert into v_all_i_transaction(id,account_from,account_to,var_sym,amount,created,status,trans_type)
values (seq_transaction_id.nextval, sys_context('bank_context','account_no'), '000000', '111111',3000,sysdate, 'NEW', 'CARD_PAY');

set echo off
pause Pre pokracovanie stlacte Enter
prompt Zadame platbu typu CARD_PAY, tentoraz v ramci limitu
pause Pre pokracovanie stlacte Enter
set echo on

insert into v_all_i_transaction(id,account_from,account_to,var_sym,amount,created,status,trans_type)
values (seq_transaction_id.nextval, sys_context('bank_context','account_no'), '000000', '111111',1000,sysdate, 'NEW', 'CARD_PAY');

set echo off
pause Pre pokracovanie stlacte Enter
prompt Zadame este jednu platbu typu CARD_PAY, ta vsak presiahne limit (2000)
pause Pre pokracovanie stlacte Enter
set echo on

insert into v_all_i_transaction(id,account_from,account_to,var_sym,amount,created,status,trans_type)
values (seq_transaction_id.nextval, sys_context('bank_context','account_no'), '000000', '111111',1001,sysdate, 'NEW', 'CARD_PAY');


set echo off
pause Pre pokracovanie stlacte Enter
prompt Zadame platbu typu CARD_ATM nad limit (1000)
pause Pre pokracovanie stlacte Enter
set echo on

insert into v_all_i_transaction(id,account_from,account_to,var_sym,amount,created,status,trans_type)
values (seq_transaction_id.nextval, sys_context('bank_context','account_no'), '000000', '111111',2000,sysdate, 'NEW', 'CARD_ATM');


set echo off
pause Pre pokracovanie stlacte Enter
prompt Zadame platbu typu CARD_ATM v ramci limitu
pause Pre pokracovanie stlacte Enter
set echo on

insert into v_all_i_transaction(id,account_from,account_to,var_sym,amount,created,status,trans_type)
values (seq_transaction_id.nextval, sys_context('bank_context','account_no'), '000000', '111111',1000,sysdate, 'NEW', 'CARD_ATM');

-- nad limit
set echo off
pause Pre pokracovanie stlacte Enter
prompt Zadame este jednu platbu typu CARD_ATM, ta vsak presiahne limit (1000)
pause Pre pokracovanie stlacte Enter
set echo on

insert into v_all_i_transaction(id,account_from,account_to,var_sym,amount,created,status,trans_type)
values (seq_transaction_id.nextval, sys_context('bank_context','account_no'), '000000', '111111',1,sysdate, 'NEW', 'CARD_ATM');

-- nad limit
set echo off
pause Pre pokracovanie stlacte Enter
prompt Terminal nema pravo prezriet transakcie, iba zadavat
prompt zmeny neaplikujeme do DB
pause Pre pokracovanie stlacte Enter
set echo on

rollback;

pause Pre pokracovanie stlacte Enter
prompt Ukoncime spojenie
exit
